/**
* \file: main.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <signal.h>

#include <string.h>

#include "control/automounter.h"
#include "control/signal_handler.h"
#include "utils/logger.h"

static error_code_t start_automounter(void);

static error_code_t daemonize_automounter(void);

int main(int argc, char* argv[])
{
	error_code_t result;

	result=automounter_init(argc,argv);

	if (result==RESULT_OK && automounter_shall_daemonize())
		result=daemonize_automounter();

	if (result==RESULT_OK)
		start_automounter();

	automounter_deinit();

	if (result==RESULT_OK || result==RESULT_HELP_PRINTED)
		return 0;
	else
		return 1;
}

static error_code_t start_automounter(void)
{
	return automounter_mainloop();
}

static error_code_t daemonize_automounter(void)
{
	pid_t pid;

	logger_close_syslog();

	pid = fork();
	if (pid < 0)
	{
		printf("Unable to fork a child process to daemonize the automounter.");
		return RESULT_INVALID;
	}

	//exit the parent
	if (pid > 0)
		exit(EXIT_SUCCESS);

	//--------------- child one from now on ----------------------------

	//make the child the session leader
	if (setsid() < 0)
	{
		printf("Unable to daemonize the automouter.");
		return RESULT_INVALID;
	}

	if (chdir ("/"))
	{
	}

	close(STDIN_FILENO);
	close(STDOUT_FILENO);
	close(STDERR_FILENO);

	logger_open_syslog();
	signal_handler_refresh();

	return RESULT_OK;
}
